/********************************************
; File: Shell.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __SHELL__
#define __SHELL__

struct GetLInfoPB {
   Ptr sfile; /* address of source file name */
   Ptr dfile; /* address of output file name */
   Ptr parms; /* address of parameter list */
   Ptr istring; /* address of language specific input string */
   Byte merr; /* max error level allowed */
   Byte merrf; /* max error level found */
   Byte lops; /* operations flag */
   Byte kflag; /* KEEP flag */
   struct GetLInfoPB **mflags; /* set of letters selected with '-' */
   struct GetLInfoPB **pflags; /* set of letters selected with '+' */
   struct GetLInfoPB **org; /* abs start address of non-relloc load file */
} ;
typedef struct GetLInfoPB GetLInfoPB, *GetLInfoPBPtr;
extern void DIRECTION();
extern void ERROR();
extern void EXECUTE();
extern Word GET_LANG();
extern void GET_LINFO();
extern void GET_VAR();
extern void INIT_WILDCARD();
extern char *NEXT_WILDCARD();
extern void READ_INDEXED();
extern void REDIRECT();
extern void SET_LANG();
extern void SET_LINFO();
extern void SET_VAR();
extern Word STOP();
extern Longint VERSION();
extern void WRITE_CONSOLE();
#endif
